/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager.Admin;

import ibm.nways.analysis.dpManager.Admin.NetworkNode;
import ibm.nways.analysis.dpManager.Admin.PanViewCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import jclass.util.JCImageCreator;

public class CanvasSettings {
    private NetworkNode serverNode;
    private Image serverIcon;
    private Image greenIcon;
    private Image yellowIcon;
    private Image redIcon;
    private Image littleBlueIcon;
    protected static final int NODE_DISPLAY_THRESH_HOLD = 25;
    private static final String[] serv_icon = new String[]{"\t\t\t\t               ", "   oooooooooooooooooooooooooooo   ", "  o............................o  ", "  o............................o  ", "  o............................o  ", "  o............................o  ", "  o............................o  ", "  o...oooooooooooooooooooooo...o  ", "  o..oXXXXXXXXXXXXXXXXXXXXXXo..o  ", "  o..oXXXXXXXXXXXXXXXXXXXXXXo..o  ", "  o..oXXXXXXXXXXXXXXXXXXXXXXo..o  ", "  o..oXXXXXXXXXXXXXXXXXXXXXXo..o  ", "  o..oXXXXXXXXXXXXXXXXXXXXXXo..o  ", "  o..oXXXXXXXXXXXXXXXXXXXXXXo..o  ", "  o..oXXXXXXXXXXXXXXXXXXXXXXo..o  ", "  o..oXXXXXXXXXXXXXXXXXXXXXXo..o  ", "  o..oXXXXXXXXXXXXXXXXXXXXXXo..o  ", "  o..oXXXXXXXXXXXXXXXXXXXXXXo..o  ", "  o..oXXXXXXXXXXXXXXXXXXXXXXo..o  ", "  o...oooooooooooooooooooooo...o  ", "  o............................o  ", "  o............................o  ", "  o.................oooooooo.  o  ", "  o............................o  ", "  o............................o  ", "   oooooooooooooooooooooooooooo   ", "   o..........................o   ", "   o..........................o   ", "   o..........................o   ", "   oooooooooooooooooooooooooooo   ", "\t\t\t\t  \t          "};
    private static final String[] dpe_icon = new String[]{"   oooooooooo   ", "  o..........o  ", "  o..oooooo..o  ", "  o.oXXXXXXo.o  ", "  o.oXXXXXXo.o  ", "  o.oXXXXXXo.o  ", "  o..oooooo..o  ", "  o..........o  ", "  o....ooooo.o  ", "  o..........o  ", "   oooooooooo   ", "   o........o   ", "   o........o   ", "   oooooooooo   "};
    private static final String[] uadpe_icon = new String[]{"   oooooooo   ", "  o........o  ", "  o..oooo..o  ", "  o.oXXXXo.o  ", "  o.oXXXXo.o  ", "  o..oooo..o  ", "  o........o  ", "   oooooooo\t", "   o......o   ", "  oooooooooo  "};
    private static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    private static final String SERVER_KEY_LABEL = adminRB.getString("s_Server");
    private static final String NORMAL_KEY_LABEL = adminRB.getString("s_Normal");
    private static final String WARNING_KEY_LABEL = adminRB.getString("s_Warning");
    private static final String OVERLOADED_KEY_LABEL = adminRB.getString("s_Overloaded");
    private static final String NODOMAIN_KEY_LABEL = adminRB.getString("s_noDomRange");

    public CanvasSettings(PanViewCanvas panViewCanvas) {
        JCImageCreator jCImageCreator = new JCImageCreator(panViewCanvas, 34, 31);
        jCImageCreator.setColor('o', Color.black);
        jCImageCreator.setColor('X', Color.white);
        jCImageCreator.setColor('$', Color.blue);
        jCImageCreator.setColor('.', Color.white);
        this.serverIcon = jCImageCreator.create(serv_icon);
        JCImageCreator jCImageCreator2 = new JCImageCreator(panViewCanvas, 16, 16);
        jCImageCreator2.setColor('o', Color.black);
        jCImageCreator2.setColor('X', Color.green);
        jCImageCreator2.setColor('.', Color.white);
        this.greenIcon = jCImageCreator2.create(dpe_icon);
        jCImageCreator2.setColor('X', Color.yellow);
        this.yellowIcon = jCImageCreator2.create(dpe_icon);
        jCImageCreator2.setColor('X', Color.red);
        this.redIcon = jCImageCreator2.create(dpe_icon);
        JCImageCreator jCImageCreator3 = new JCImageCreator(panViewCanvas, 14, 10);
        jCImageCreator3.setColor('o', Color.black);
        jCImageCreator3.setColor('X', Color.blue);
        jCImageCreator3.setColor('.', Color.white);
        this.littleBlueIcon = jCImageCreator3.create(uadpe_icon);
    }

    public void drawKey(Graphics graphics, Dimension dimension) {
        int n = 10;
        int n2 = 10;
        int n3 = 10;
        int n4 = dimension.height - dimension.height / 5;
        graphics.setColor(Color.white);
        graphics.fillRect(n3, n4, n, n2);
        graphics.setColor(Color.black);
        graphics.drawRect(n3, n4, n, n2);
        graphics.drawString(SERVER_KEY_LABEL, n3 + 15, n4 + 10);
        graphics.setColor(Color.green);
        graphics.fillRect(n3, n4 += 15, n, n2);
        graphics.setColor(Color.black);
        graphics.drawRect(n3, n4, n, n2);
        graphics.drawString(NORMAL_KEY_LABEL, n3 + 15, n4 + 10);
        graphics.setColor(Color.yellow);
        graphics.fillRect(n3, n4 += 15, n, n2);
        graphics.setColor(Color.black);
        graphics.drawRect(n3, n4, n, n2);
        graphics.drawString(WARNING_KEY_LABEL, n3 + 15, n4 + 10);
        graphics.setColor(Color.red);
        graphics.fillRect(n3, n4 += 15, n, n2);
        graphics.setColor(Color.black);
        graphics.drawRect(n3, n4, n, n2);
        graphics.drawString(OVERLOADED_KEY_LABEL, n3 + 15, n4 + 10);
        graphics.setColor(Color.blue);
        graphics.fillRect(n3, n4 += 15, n, n2);
        graphics.setColor(Color.black);
        graphics.drawRect(n3, n4, n, n2);
        graphics.drawString(NODOMAIN_KEY_LABEL, n3 + 15, n4 + 10);
        graphics.setColor(Color.black);
    }

    public void drawNodeLabel(Graphics graphics, NetworkNode networkNode, FontMetrics fontMetrics) {
        int n = networkNode.getNodeX();
        int n2 = networkNode.getNodeY();
        int n3 = 0;
        int n4 = 0;
        n3 = n - 8;
        n4 = n2 - 8;
        String string = networkNode.getNodeLabel();
        int n5 = fontMetrics.stringWidth(string) + 10;
        int n6 = fontMetrics.getHeight();
        int n7 = this.serverNode.getNodeX();
        this.serverNode.getNodeY();
        if (networkNode.equals(this.serverNode)) {
            n = networkNode.getNodeX();
            n2 = networkNode.getNodeY();
            graphics.setColor(Color.white);
            graphics.fillRect(n - n5 / 2, n2 + n6 + 5, n5, n6);
            graphics.setColor(Color.black);
            graphics.drawRect(n - n5 / 2, n2 + n6 + 5, n5 - 1, n6 - 1);
            graphics.setColor(Color.black);
            graphics.drawString(string, n - n5 / 2 + 5, n2 + n6 + 5 + fontMetrics.getAscent());
        } else if (n3 > n7) {
            graphics.setColor(Color.white);
            graphics.fillRect(n + 10, n2 - n6 / 2, n5, n6);
            graphics.setColor(Color.black);
            graphics.drawRect(n + 10, n2 - n6 / 2, n5 - 1, n6 - 1);
            graphics.setColor(Color.black);
            graphics.drawString(string, n + 15, n2 - n6 / 2 + fontMetrics.getAscent());
        } else if (n3 < n7) {
            graphics.setColor(Color.white);
            graphics.fillRect(n - n5 - 10, n2 - n6 / 2, n5, n6);
            graphics.setColor(Color.black);
            graphics.drawRect(n - n5 - 10, n2 - n6 / 2, n5 - 1, n6 - 1);
            graphics.setColor(Color.black);
            graphics.drawString(string, n - n5 - 5, n2 - n6 / 2 + fontMetrics.getAscent());
        }
        graphics.setColor(Color.black);
    }

    public void drawNode(Graphics graphics, NetworkNode networkNode, FontMetrics fontMetrics) {
        int n = 0;
        int n2 = 0;
        if (networkNode.equals(this.serverNode)) {
            n = networkNode.getNodeX() - 18;
            n2 = networkNode.getNodeY() - 16;
        } else {
            n = networkNode.getNodeX() - 8;
            n2 = networkNode.getNodeY() - 8;
        }
        int n3 = 0;
        n3 = networkNode.getNodeColor();
        switch (n3) {
            case 0: {
                graphics.drawImage(this.serverIcon, n, n2, null);
                return;
            }
            case 1: {
                graphics.drawImage(this.greenIcon, n, n2, null);
                return;
            }
            case 2: {
                graphics.drawImage(this.yellowIcon, n, n2, null);
                return;
            }
            case 3: {
                graphics.drawImage(this.redIcon, n, n2, null);
                return;
            }
        }
        System.out.println("unknown color_flag");
    }

    public void drawAssignedDPEs(Graphics graphics, Vector vector, FontMetrics fontMetrics, NetworkNode networkNode, int n) {
        int n2 = 0;
        int n3 = 0;
        this.serverNode = networkNode;
        n2 = vector.size();
        double d = Math.PI * 2 / (double)n2;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            NetworkNode networkNode2 = (NetworkNode)enumeration.nextElement();
            int n4 = networkNode.getNodeX();
            int n5 = networkNode.getNodeY();
            networkNode2.setNodeX(n4 + (int)((double)n * Math.cos((double)(++n3) * d)));
            networkNode2.setNodeY(n5 + (int)((double)n * Math.sin((double)n3 * d)));
            int n6 = networkNode2.getNodeX();
            int n7 = networkNode2.getNodeY();
            graphics.drawLine(n4, n5, n6, n7);
            this.drawNode(graphics, networkNode2, fontMetrics);
            if (n2 > 25) continue;
            this.drawNodeLabel(graphics, networkNode2, fontMetrics);
        }
        this.drawNode(graphics, networkNode, fontMetrics);
        this.drawNodeLabel(graphics, networkNode, fontMetrics);
    }

    public void drawImageDragged(Graphics graphics, int n, int n2, String string) {
        graphics.drawImage(this.littleBlueIcon, n, n2, null);
        graphics.drawString(string, n + 20, n2 + 7);
    }

    public void drawUnAssignedDPEs(Graphics graphics, Vector vector) {
        int n = 10;
        int n2 = 10;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            NetworkNode networkNode = (NetworkNode)enumeration.nextElement();
            networkNode.setNodeX(n);
            networkNode.setNodeY(n2);
            String string = networkNode.getNodeLabel();
            graphics.drawImage(this.littleBlueIcon, n, n2, null);
            graphics.drawString(string, n + 20, n2 + 7);
            n2 += 20;
        }
    }
}

